#!/bin/sh
MOBILE_APN=`/usr/bin/sys_params services/mobile/apn`
AUTH_TYPE=`/usr/bin/sys_params -l services/mobile/auth/type`
if [ "${AUTH_TYPE}" = "1" ]; then
  AUTH_USER=`/usr/bin/sys_params -l services/mobile/auth/user`
  AUTH_PWD=`/usr/bin/sys_params -l services/mobile/auth/pass`
fi
PLCM_VERSION=`/usr/bin/modem plcrel`

cat << EOF
# *PLEASE DO NOT MODIFY* - Automatically generated by '$(basename $0)'

# You can use this script unmodified to connect to cellular networks.
# The APN is specified in the peers file as the argument of the -T command
# line option of chat(8).

# For details about the AT commands involved please consult the relevant
# standard: 3GPP TS 27.007 - AT command set for User Equipment (UE).
# (http://www.3gpp.org/ftp/Specs/html-info/27007.htm)

ABORT       BUSY
ABORT       VOICE
ABORT       "NO CARRIER"
ABORT       "NO DIALTONE"
ABORT       "NO DIAL TONE"
ABORT       "NO ANSWER"
ABORT       "DELAYED"
ABORT       "ERROR"

# cease if the modem is not attached to the network yet
ABORT       "+CGATT: 0"

""          AT
TIMEOUT     30

OK          ATH
OK          ATE1
# DTR usage not available - disable it
OK          AT&D0

EOF

# Special handling only for PAP authentication on PLCM >= 10 (includes 8)
if [ "${PLCM_VERSION}" != "9" -a "${AUTH_TYPE}" = "1" ]; then
  echo "OK          AT+CFUN=0"  # minimum functionality [BSP-3306 PLCM10 not failing on first attempt with bad credentials]
  echo "OK          AT+QICSGP=1,1,\"${MOBILE_APN}\",\"${AUTH_USER}\",\"${AUTH_PWD}\",3"
  echo "OK          AT+CFUN=1"  # full functionality
else
  echo "OK          AT+CGDCONT=1,\"IP\",\"${MOBILE_APN}\",\"0.0.0.0\",0,0"
fi

cat << EOF
#OK          ATD*99#
OK          ATD*99***1#

CONNECT     ""
EOF
